    NAME OsPromSubs

    PUBLIC  CompareChars, Upper, CpConPeekChar

CGROUP GROUP CODE

true EQU 0ffh
false EQU 0

CODE SEGMENT BYTE PUBLIC 'CODE'
    ASSUME  CS:CGROUP



;  Upper: PROCEDURE (char) BYTE CLEAN;
;    DCL char BYTE;
;
;    This will return the upper case value of a letter.
;    This routine is called by CompareChars which expects the
;    following registers to be preserved:
;      BX, CX, DS, ES, SI, DI, BP, Direction flag


char EQU BYTE PTR [BP+6]

Upper PROC FAR
    PUSH BP
    MOV  BP, SP

    MOV  AL, char
    CMP  AL, 'a'
    JB   UpperExit
    CMP  AL, 'z'
    JA   UpperExit
    AND  AL, 0DFH

UpperExit:
    POP  BP
    RET  2
Upper ENDP

PURGE char

$EJECT

;  CompareChars: PROCEDURE (pString1, pString2, length) BOOLEAN CLEAN;
;    DCL lenCompare WORD;
;    DCL pString1   PTR;
;    DCL pString2   PTR;
;
;    This will return TRUE if two buffers are equal.  Case is ignored.
;
;    NOTE: This routine depends on the routine
;      Upper only changing register AL.

lenCompare EQU WORD  PTR [BP+8]
pString2   EQU DWORD PTR [BP+10]
pString1   EQU DWORD PTR [BP+14]

CompareChars PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    CLD
    MOV  CX, lenCompare
    JCXZ CompareEqual

    LDS  SI, pString1
    LES  DI, pString2

CompareTopOfLoop:
    LODSB                 ; get the Upper of the (& point to next str1 char)
    PUSH AX
    CALL Upper            ; byte at string1 (next)
    MOV  BL, AL           ; save this Upper value

    MOV  AL, ES:[DI]      ; get the Upper of the
    PUSH AX
    CALL Upper            ; byte at string2 (next)

    CMP  AL, BL           ; if the characters
    MOV  AL, false        ; do not match, then
    JNZ  CompareExit      ; RETURN (FALSE)

    INC  DI               ; point to next str2 char
    LOOP CompareTopOfLoop ; keep checking

CompareEqual:
    MOV  AL, true         ; RETURN (TRUE);

CompareExit:
    POP  BP
    POP  DS
    RET  10
CompareChars ENDP

PURGE lenCompare, pString2, pString1
$EJECT

;  CpConPeekChar: PROCEDURE BYTE CLEAN;
;
;  This routine will see if a key is in the keyboard buffer. If so it will
;  return the key.  If not, it will return NULLBYTE.
;
CpConPeekChar PROC NEAR
  MOV AH,1
  INT 16h              ; IF ConKeyPressed THEN
  JNZ CpPeekGotChar
  MOV AL, 0FFh         ;   RETURN (NULLBYTE)
  RET

CpPeekGotChar:
  MOV AH, 0            ; ELSE
  INT 16h              ;   RETURN (ConCharIn);
  RET
CpConPeekChar ENDP

CODE ENDS

END
